/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.model.AnalogFilterParameter;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.model.AverageValueParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.DataLogParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.IOParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.MaxMinParameter;
import DE.siemens.ad.logo.model.NetworkConfiguration;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.SOutputParameter;
import DE.siemens.ad.logo.model.ShiftRegisterParameter;
import DE.siemens.ad.logo.model.StopWatchParameter;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogFilterBlock;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.AstronomicalClockBlock;
import DE.siemens.ad.logo.model.block.AverageValueBlock;
import DE.siemens.ad.logo.model.block.DataLogBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.HighBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.LowBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.MaxMinBlock;
import DE.siemens.ad.logo.model.block.NetworkNodeBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.SOutputBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.StopWatchBlock;
import DE.siemens.ad.logo.model.hardware.Logo4;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo6;
import DE.siemens.ad.logo.model.visitor.build.UDFConstants;
import DE.siemens.ad.logo.util.AnchorMemory16;
import DE.siemens.ad.logo.util.AnchorMemoryEnumerator;
import DE.siemens.ad.logo.util.AnchorMemoryEnumeratorV7;
import DE.siemens.ad.logo.util.IPV4Utils;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.MemoryEnumeration;
import DE.siemens.ad.logo.util.NetworkMemoryV7;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgramMemory16;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class CompilerFromLogo7
extends CompilerFromLogo6 {
    public WiringDiagram compile(Hardware hw) throws ProgramException {
        WiringDiagram wd = super.compile(hw);
        new UDFUploadHandler().handle(wd);
        this.restoreDatalogBlock(wd);
        this.readNetworkParameter(hw, wd);
        return wd;
    }

    private void readNetworkParameter(Hardware hw, WiringDiagram wd) {
        NetworkMemoryV7 memory = (NetworkMemoryV7)this.fHardware.getMemory("Network Memory");
        Memory16 programOffsetTable = (Memory16)this.fHardware.getMemory("ProgOffsetTabelle");
        NetworkConfiguration networkInfo = new NetworkConfiguration(this.fHardware);
        memory.readNetworkConfiguration(networkInfo);
        wd.setNetworkInfo(networkInfo);
        wd.setBlockVMMappingInfo(memory.readBlockVMMappingInfo(wd, programOffsetTable));
        Enumeration enumeration = wd.getBlocks().elements();
        while (enumeration.hasMoreElements()) {
            Block block = (Block)enumeration.nextElement();
            if (block instanceof NetworkNodeBlock) {
                this.readNParameter((NetworkNodeBlock)block);
            }
            if (!(block instanceof SOutputBlock)) continue;
            this.readSQParameter((SOutputBlock)block);
        }
    }

    private void readSQParameter(SOutputBlock block) {
        NetworkMemoryV7 memory = (NetworkMemoryV7)((Logo7)this.fHardware).getMemory("Network Memory");
        SOutputParameter param = (SOutputParameter)block.getParameter();
        int offset = memory.getOffsetForNetworkBlockInfo(block.getNumberType()) + (block.getNumber() - 1) * 5;
        memory.setPosition(offset);
        param.setAddress(IPV4Utils.getInstance().formatToString(memory.nextDoubleWord()));
        param.setConfiguredBlockNumber(memory.nextByte());
    }

    private void readNParameter(NetworkNodeBlock block) {
        NetworkMemoryV7 memory = (NetworkMemoryV7)((Logo7)this.fHardware).getMemory("Network Memory");
        NetworkNodeParameter param = (NetworkNodeParameter)block.getParameter();
        int offset = memory.getOffsetForNetworkBlockInfo(block.getNumberType()) + (block.getNumber() - 1) * 6;
        memory.setPosition(offset);
        int number = memory.nextByte();
        int type = memory.nextByte();
        param.setForSlave((type & 0x80) == 128);
        if (param.isForSlave()) {
            param.setConfiguredBlockNumber(number);
            param.setConfiguredBlockType(type & 0x7F);
            param.setAddress(IPV4Utils.getInstance().formatToString(memory.nextDoubleWord()));
        } else {
            param.setBitNumber(type >> 2);
            param.setVMAddress((type & 3) << 8 | number);
            memory.nextDoubleWord();
            param.setForDiagnostic(param.getVMAddress() == 984);
            param.setConfiguredDiagnosticType(param.getBitNumber());
        }
    }

    protected int getOffsetAddress(Memory programOffsetTable, int prgLineNr) {
        return programOffsetTable.getWord((prgLineNr - 10) * 2);
    }

    public void compileAnchors(AnchorMemory16 memory) {
        this.compileAnchors(memory, memory.getFirstOpcode() == 768);
    }

    protected AnchorMemoryEnumerator getAnchorMemoryEnumerator(AnchorMemory16 memory) {
        return new AnchorMemoryEnumeratorV7(memory);
    }

    protected int calculateAnchorNumber(int firstOpcode, int offset, boolean isAnalog) {
        return offset + 1;
    }

    public void compile(ShiftRegisterBlock block) {
        super.compile(block);
        int index = this.fProgramMemory.nextByte() - 1;
        ((ShiftRegisterParameter)block.getParameter()).setIndex(index, false);
    }

    public void compile(AnalogFilterBlock block) {
        this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        ((AnalogFilterParameter)block.getParameter()).setSampleNumber((int)Math.pow(2.0, this.fProgramMemory.nextByte()));
    }

    public void compile(AverageValueBlock block) {
        this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        AverageValueParameter param = (AverageValueParameter)block.getParameter();
        int samplingTime = this.fProgramMemory.nextWord();
        param.setSamplingTime(new TimeBase(samplingTime & 7, samplingTime >> 3));
        param.getSampleNumber().setCurrentValue(this.fProgramMemory.nextWord());
    }

    public void compile(StopWatchBlock block) {
        this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        ((StopWatchParameter)block.getParameter()).setOutputTimeBase(new TimeBase(this.fProgramMemory.nextByte()));
    }

    public void compile(MaxMinBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "Mode", block.getParameter());
        ((MaxMinParameter)block.getParameter()).setResetMaxMin(this.fProgramMemory.nextByte() == 1);
    }

    public void compile(AstronomicalClockBlock block) {
        this.fProgramMemory.nextWord();
        AstronomicalClockParameter param = (AstronomicalClockParameter)block.getParameter();
        int longSec = this.fProgramMemory.nextByte();
        int longMin = this.fProgramMemory.nextByte();
        int longDec = this.fProgramMemory.nextByte();
        int dir = this.fProgramMemory.nextByte();
        param.setLongitude(new AstronomicalClockParameter.Theodolite(0, dir, longDec, longMin, longSec));
        int latiSec = this.fProgramMemory.nextByte();
        int latiMin = this.fProgramMemory.nextByte();
        int latiDec = this.fProgramMemory.nextByte();
        dir = this.fProgramMemory.nextByte();
        param.setLatitude(new AstronomicalClockParameter.Theodolite(1, dir, latiDec, latiMin, latiSec));
        int timeZone = this.fProgramMemory.nextByte();
        param.setTimeZone((timeZone >> 7 == 1 ? -1 : 1) * Integer.valueOf(timeZone & 0x7F));
    }

    public void compile(MathDetectionBlock block) {
        MathDetectionParameter param = (MathDetectionParameter)block.getParameter();
        this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        int progkNr = this.fProgramMemory.nextWord();
        if (progkNr != 65535) {
            param.setReferencedBlockNumber(this.getBlockNumber(progkNr));
        } else {
            param.setReferencedBlockNumber(-1);
        }
        param.setAutoResetMode(this.fProgramMemory.nextByte() != 0);
        this.fProgramMemory.nextByte();
        int detectErr = this.fProgramMemory.nextByte();
        param.setDetectOverflow((detectErr & 1) > 0);
        param.setDetectZeroDivision((detectErr & 2) > 0);
    }

    protected boolean isReferenceInLogo(int ref) {
        return (ref & 0x3FF) != 0;
    }

    public boolean isReferenceToBlock(int ref) {
        if ((ref & 0x4000) > 0) {
            return (ref & 0x3FF) != 0 && (ref & 0x3FF) != 1023;
        }
        return (ref & 0x3FF) != 0;
    }

    protected boolean isNegated(int reference) {
        return (reference & 0x4000) > 0;
    }

    protected Block createIOMBlock(int reference) {
        ConstantBlock block = null;
        int highPart = (reference & 0xC000) >> 8;
        int lowPart = reference & 0x3FF;
        if ((highPart & 0x80) <= 0) {
            int opcode = lowPart;
            int blockNumber = this.fHardware.calculateBlockNumber(opcode);
            if (((Logo4)this.fHardware).getOpcodeCO("Input", blockNumber) == (opcode |= 0x1000000)) {
                block = new InputBlock();
            } else if (((Logo4)this.fHardware).getOpcodeCO("AnalogInput", blockNumber) == opcode) {
                block = new AnalogInputBlock();
            } else if (((Logo4)this.fHardware).getOpcodeCO("Output", blockNumber) == opcode) {
                block = new OutputBlock();
            } else if (((Logo4)this.fHardware).getOpcodeCO("AnalogOutput", blockNumber) == opcode) {
                block = new AnalogOutputBlock();
            } else if (((Logo4)this.fHardware).getOpcodeCO("Marker", blockNumber) == opcode) {
                block = new MarkerBlock();
            } else if (((Logo4)this.fHardware).getOpcodeCO("AnalogMarker", blockNumber) == opcode) {
                block = new AnalogMarkerBlock();
            }
            if (block != null) {
                block.setNumber(blockNumber);
            }
        }
        return block;
    }

    private boolean isOpcodeOfIOMBlock(int opcode, int blockNr) {
        if (((Logo4)this.fHardware).getOpcodeCO("Input", blockNr) == opcode) {
            return true;
        }
        if (((Logo4)this.fHardware).getOpcodeCO("AnalogInput", blockNr) == opcode) {
            return true;
        }
        if (((Logo4)this.fHardware).getOpcodeCO("Output", blockNr) == opcode) {
            return true;
        }
        if (((Logo4)this.fHardware).getOpcodeCO("AnalogOutput", blockNr) == opcode) {
            return true;
        }
        if (((Logo4)this.fHardware).getOpcodeCO("Marker", blockNr) == opcode) {
            return true;
        }
        return ((Logo4)this.fHardware).getOpcodeCO("AnalogMarker", blockNr) == opcode;
    }

    private boolean isReferenceToIOMBlock(int reference) {
        int blockNumber;
        int highPart = (reference & 0xC000) >> 8;
        int lowPart = reference & 0x3FF;
        if ((highPart & 0x80) > 0) {
            return false;
        }
        int opcode = lowPart;
        return this.isOpcodeOfIOMBlock(opcode |= 0x1000000, blockNumber = this.fHardware.calculateBlockNumber(opcode));
    }

    protected void connect(Block source, int sourceConnectorNr, int reference) {
        super.connect(source, sourceConnectorNr, reference);
    }

    protected void restoreDatalogBlock(WiringDiagram wd) {
        DataLogBlock datalogBlock = null;
        Enumeration blockEnum = this.fWiringDiagram.getBlocks().elements();
        while (blockEnum.hasMoreElements()) {
            Block block = (Block)blockEnum.nextElement();
            if (!(block instanceof DataLogBlock)) continue;
            datalogBlock = (DataLogBlock)block;
        }
        if (datalogBlock == null) {
            return;
        }
        DataLogParameter param = (DataLogParameter)datalogBlock.getParameter();
        ParameterItemList paraList = param.getParameterItemList();
        Memory memory = this.fHardware.getMemory("Datalog Profile Memory");
        memory.setPosition(0);
        for (int i = 0; i < wd.getHardware().getIntProperty("maximumDatalogRecords"); ++i) {
            int blockReference = memory.nextWord();
            int parameterIndex = memory.nextByte();
            int UDFParameterIndex = memory.nextByte();
            Block block = null;
            ParameterItem paraItem = null;
            if (!this.isReferenceToBlock(blockReference)) continue;
            if (this.isReferenceToIOMBlock(blockReference)) {
                block = this.createIOMBlock(blockReference);
                IOParameter blockPara = new IOParameter(block);
                paraItem = new ParameterItem();
                paraItem.setParameter(blockPara);
            } else {
                block = this.getTarget(blockReference);
                Block outsideBlock = this.fWiringDiagram.getOutestBlock(block);
                paraItem = outsideBlock instanceof UDFBlock ? ((UDFBlock)outsideBlock).getParameter().getParameterItems().getParameterItem(UDFParameterIndex & 0x7F) : block.getParameter().getParameterItem(parameterIndex);
            }
            if (paraItem == null) continue;
            paraList.add(paraItem);
        }
    }

    protected int getProgLineNrOfNameOffset(MemoryEnumeration offsetElements) {
        int ret = offsetElements.nextWord();
        if (ret == 65535) {
            return -1;
        }
        return ret;
    }

    protected void setReference(ValueOrItemReference value, int memValueWord) {
        if ((memValueWord & 0x2000) > 0) {
            Reference currentValue = new Reference();
            currentValue.setVMDataLength(this.getLength(memValueWord));
            currentValue.setAddress(memValueWord & 0x3FF);
            ((TimeValueProperties)value).setCurrentValue(currentValue);
        } else {
            value.setReference(this.getReferencedParameterItem(memValueWord & 0x3FF));
        }
    }

    private int getLength(int memValueWord) {
        int value = memValueWord & 0x1800;
        if (value == 4096) {
            return 4;
        }
        if (value == 2048) {
            return 2;
        }
        if (value == 0) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public RemoteCompilerFromLogo7 getRemoteCompiler(Logo hw) {
        RemoteCompilerFromLogo7 ret = new RemoteCompilerFromLogo7();
        ret.fHardware = hw;
        ret.fProgramMemory = (ProgramMemory16)hw.getMemory("Program");
        return ret;
    }

    private class UDFUploadHandler {
        int fMacroTypes;
        int fMacroCount;
        int fBlockCount;
        int fSpecialBlockCount;
        int fTopLevelUDFs;
        int[][] fConnectorCount;
        long[] fMacroGUIDs;
        int[][] fMacroIds;
        int[][] fMacroUserDefinedNames;
        int[][] fMacroPasswords;
        int[][] fMacroOutputs;
        int[][] fMacroParams;
        char[][] fMacroParamNames;
        int[] fMacroType;
        int[][] fBlockToMacro;
        int[][] fSpecialBlockToMacro;
        int[][] fMacroToMacro;
        Set<Integer> topUDFNumbers = new TreeSet<Integer>();

        private UDFUploadHandler() {
        }

        private UDFBlock restoreUDFBlock(WiringDiagram wd, int macroNr) {
            int order;
            int off;
            int i;
            UDFBlock macro = new UDFBlock(wd, this.fConnectorCount[this.fMacroType[macroNr - 1]][0], this.fConnectorCount[this.fMacroType[macroNr - 1]][1]);
            macro.setNumber(macroNr);
            macro.setSourceLocateFlag(1);
            macro.getGuidManager().addGuid("1.0.0", this.fMacroGUIDs[this.fMacroType[macroNr - 1]]);
            int[] intMacroIden = this.fMacroIds[this.fMacroType[macroNr - 1]];
            char[] chMacroIden = new char[intMacroIden.length];
            for (int i2 = 0; i2 < intMacroIden.length; ++i2) {
                chMacroIden[i2] = (char)intMacroIden[i2];
            }
            macro.setIdentifier(String.copyValueOf(chMacroIden));
            int[] userDefinedName = this.fMacroUserDefinedNames[macroNr - 1];
            String strName = CompilerFromLogo7.this.getTextFromMessageLine(userDefinedName, 0);
            macro.setUserDefinedName(strName);
            boolean hasAnyBlock = false;
            for (i = 0; i < this.fBlockCount; ++i) {
                Block block;
                if (this.fBlockToMacro[i][0] != macroNr - 1 || (block = wd.getExpansionBlockByNumber(0, i + 1)) == null) continue;
                if (!hasAnyBlock) {
                    hasAnyBlock = true;
                }
                macro.add(block);
                wd.deleteBlockForUDF(block);
                int input = this.fBlockToMacro[i][1];
                for (int inIdx = 0; inIdx < 4 && inIdx < block.getInConnectorCount(); ++inIdx) {
                    int macroInIdx = input >> inIdx * 4 & 0xF;
                    this.redirectInputToUDF(block.getInConnector(inIdx), macro, macroInIdx);
                }
            }
            if (!hasAnyBlock) {
                new LogoError(Application.getInstance().getWindow(), "upload.noBlockInUDF", "The wiring diagram from BM is broken,  no block found in UDF.", 0).display();
                return null;
            }
            for (i = 0; i < this.fSpecialBlockCount; ++i) {
                int paEncoding;
                Block block;
                if (this.fSpecialBlockToMacro[i][0] != macroNr - 1 || (block = CompilerFromLogo7.this.getBlock((paEncoding = UDFConstants.getPAEncoding(i)) | 0x1000000, ((Logo)wd.getHardware()).calculateBlockNumber(paEncoding))) == null) continue;
                macro.add(block);
                wd.deleteBlockForUDF(block);
                int macroInIdx = this.fSpecialBlockToMacro[i][1] & 0xF;
                this.redirectInputToUDF(block.getInConnector(0), macro, macroInIdx);
            }
            UDFBlockParameter mp = (UDFBlockParameter)macro.getParameter();
            int[] params = this.fMacroParams[this.fMacroType[macroNr - 1]];
            for (int i3 = 0; i3 < 8 && params[(off = i3 * 2) + 1] != 255; ++i3) {
                char c;
                order = params[off];
                int idx = params[off + 1] & 0x3F;
                Block blk = macro.getBlockByOrder(order, true);
                StringBuffer name = new StringBuffer();
                for (int x = i3 * 4; x < (i3 + 1) * 4 && (c = this.fMacroParamNames[this.fMacroType[macroNr - 1]][x]) != '\u0000'; ++x) {
                    name.append(c);
                }
                mp.addItem(name.toString(), blk, ((ParameterItem)blk.getParameter().getParameterItems().get(idx)).getIdentifier());
            }
            macro.setUDFBlockParameter(mp);
            int[] output = this.fMacroOutputs[this.fMacroType[macroNr - 1]];
            for (int idx = 0; idx < output.length / 2; ++idx) {
                order = output[2 * idx];
                int info = output[2 * idx + 1];
                if (order == 255) continue;
                Block child = macro.getBlockByOrder(order, (info & 0xF0) == 0);
                this.redirectOutputToUDF(child.getOutConnector(info & 0xF), macro, idx);
            }
            return macro;
        }

        public void handle(WiringDiagram wd) {
            if (!this.readToBuffers()) {
                return;
            }
            this.deleteInvalidUDFs();
            for (int number : this.topUDFNumbers) {
                UDFBlock topUDF = this.restoreUDFBlock(wd, number);
                wd.insert(topUDF);
            }
            this.restoreReferencesToUDF(wd);
        }

        private void restoreReferencesToUDF(WiringDiagram wd) {
            Map<ParameterItem, ParameterItem> FBParaToUdfRerences = wd.getUDFReferences();
            for (ParameterItem referingItem : FBParaToUdfRerences.keySet()) {
                boolean fIsRestoreDone = false;
                ParameterItem referredItem = FBParaToUdfRerences.get(referingItem);
                Enumeration enumeration = wd.getBlocks().elements();
                block1: while (!fIsRestoreDone && enumeration.hasMoreElements()) {
                    BlockParameter param;
                    Block block = (Block)enumeration.nextElement();
                    if (block.getNumberType() != 25 || (param = block.getParameter()) == null) continue;
                    ParameterItemList list = param.getParameterItems().getParameterSourceItems();
                    for (ParameterItem parameterItem : list) {
                        ParameterItem sourceItem = ((UDFParameterItem)parameterItem).getRootSourceParameterItem();
                        if (referredItem.getParameterNumber() != sourceItem.getParameterNumber() || referredItem.getParameter().getBlock().getNumber() != sourceItem.getParameter().getBlock().getNumber() || referredItem.getParameter().getBlock().getNumberType() != sourceItem.getParameter().getBlock().getNumberType()) continue;
                        ValueOrItemReference valueOrRef = (ValueOrItemReference)referingItem.getValue();
                        valueOrRef.setReference(parameterItem.getInstanceForParameter(param));
                        referingItem.setValue(valueOrRef);
                        fIsRestoreDone = true;
                        continue block1;
                    }
                }
            }
        }

        private void redirectInputToUDF(InBlockConnector in, UDFBlock udf, int udfInIdx) {
            if (udfInIdx != 15) {
                DeputyBlock aDeputy;
                if (udf.getInConnector(udfInIdx) == null) {
                    aDeputy = new DeputyBlock(CompilerFromLogo7.this.fWiringDiagram);
                    aDeputy.setParent(udf);
                    udf.add(aDeputy);
                    aDeputy.setBinaryAnalogType(in.getSignalType());
                    aDeputy.setInputType(true);
                    udf.setInputDeputy(udfInIdx, aDeputy);
                }
                aDeputy = udf.getInputDeputy(udfInIdx);
                OutBlockConnector outside = in.getLinkedConnector();
                if (outside != null) {
                    in.disconnect(outside);
                    outside.connect(aDeputy.getInConnector(0));
                }
                in.connect(aDeputy.getOutConnector(0));
            } else {
                Block linkedBlock = in.getLinkedBlock();
                if (linkedBlock instanceof HighBlock || linkedBlock instanceof LowBlock) {
                    udf.add(linkedBlock);
                }
            }
        }

        private void redirectOutputToUDF(OutBlockConnector out, UDFBlock udf, int udfOutIdx) {
            if (out.getLinkedConnectorsCount() > 0) {
                DeputyBlock aDeputy;
                if (udf.getOutConnector(udfOutIdx) == null) {
                    aDeputy = new DeputyBlock(CompilerFromLogo7.this.fWiringDiagram);
                    aDeputy.setParent(udf);
                    udf.add(aDeputy);
                    aDeputy.setBinaryAnalogType(out.getSignalType());
                    aDeputy.setInputType(false);
                    udf.setOutputDeputy(udfOutIdx, aDeputy);
                }
                aDeputy = udf.getOutputDeputy(udfOutIdx);
                Vector inBlockConnectors = out.getNextConnectorsVar();
                int count = inBlockConnectors.size();
                for (int i = 0; i < count; ++i) {
                    InBlockConnector in = (InBlockConnector)inBlockConnectors.get(0);
                    if (in == null) continue;
                    in.disconnect(out);
                    in.connect(aDeputy.getOutConnector(0));
                }
                out.connect(aDeputy.getInConnector(0));
            }
        }

        public boolean readToBuffers() {
            int i;
            Memory memory = CompilerFromLogo7.this.fHardware.getMemory("UDF Memory");
            memory.setPosition(0);
            this.fMacroTypes = memory.nextWord();
            if (this.fMacroTypes == 0) {
                return false;
            }
            this.fMacroCount = memory.nextWord();
            this.fBlockCount = CompilerFromLogo7.this.fHardware.getMaxResource(0);
            this.fSpecialBlockCount = CompilerFromLogo7.this.fHardware.getIntProperty("maxPAEncodingCountInUDF");
            this.fTopLevelUDFs = memory.nextWord();
            this.fMacroGUIDs = new long[this.fMacroTypes];
            this.fMacroIds = new int[this.fMacroTypes][8];
            this.fMacroUserDefinedNames = new int[64][8];
            this.fMacroPasswords = new int[this.fMacroTypes][10];
            this.fMacroOutputs = new int[this.fMacroTypes][8];
            this.fMacroParams = new int[this.fMacroTypes][16];
            this.fMacroParamNames = new char[this.fMacroTypes][32];
            this.fConnectorCount = new int[this.fMacroTypes][4];
            for (i = 0; i < this.fMacroTypes; ++i) {
                int j;
                long lowDoubleWord = memory.nextDoubleWord();
                long lowWord = lowDoubleWord & 0xFFFFL;
                long highWord = lowDoubleWord >> 16 & 0xFFFFL;
                long combinedLowDoubleWord = highWord << 16 | lowWord;
                long highDoubleWord = memory.nextDoubleWord();
                this.fMacroGUIDs[i] = highDoubleWord << 32 | combinedLowDoubleWord;
                this.fConnectorCount[i][0] = memory.nextByte();
                this.fConnectorCount[i][1] = memory.nextByte();
                this.fConnectorCount[i][2] = memory.nextByte();
                this.fConnectorCount[i][3] = memory.nextByte();
                for (j = 0; j < 8; ++j) {
                    this.fMacroIds[i][j] = memory.nextByte();
                }
                for (j = 0; j < 10; ++j) {
                    this.fMacroPasswords[i][j] = memory.nextByte();
                }
                for (j = 0; j < 8; ++j) {
                    this.fMacroOutputs[i][j] = memory.nextByte();
                }
                for (j = 0; j < 16; ++j) {
                    this.fMacroParams[i][j] = memory.nextByte();
                }
                for (j = 0; j < 32; ++j) {
                    this.fMacroParamNames[i][j] = (char)memory.nextByte();
                }
            }
            this.fMacroType = new int[64];
            for (i = 0; i < this.fMacroType.length; ++i) {
                this.fMacroType[i] = memory.nextByte();
            }
            this.fBlockToMacro = new int[this.fBlockCount][2];
            for (i = 0; i < this.fBlockCount; ++i) {
                this.fBlockToMacro[i][0] = memory.nextByte();
                this.fBlockToMacro[i][1] = memory.nextWord();
            }
            this.fSpecialBlockToMacro = new int[this.fSpecialBlockCount][2];
            for (i = 0; i < this.fSpecialBlockCount; ++i) {
                this.fSpecialBlockToMacro[i][0] = memory.nextByte();
                this.fSpecialBlockToMacro[i][1] = memory.nextByte();
            }
            this.fMacroToMacro = new int[this.fMacroCount][2];
            for (i = 0; i < this.fMacroCount; ++i) {
                this.fMacroToMacro[i][0] = memory.nextByte();
                this.fMacroToMacro[i][1] = memory.nextDoubleWord();
                if (this.fMacroToMacro[i][0] != 254) continue;
                this.topUDFNumbers.add(i + 1);
            }
            int startPos = memory.getPosition();
            for (int i2 = 0; i2 < this.fTopLevelUDFs; ++i2) {
                int instanceID = memory.nextByte();
                memory.setPosition(startPos + (i2 + 1) * 58 - 8);
                for (int j = 0; j < 8; ++j) {
                    this.fMacroUserDefinedNames[instanceID][j] = memory.nextByte();
                }
            }
            return true;
        }

        private void deleteInvalidUDFs() {
            boolean changed;
            do {
                changed = false;
                for (int i = 0; i < this.fMacroToMacro.length; ++i) {
                    int parentID = this.fMacroToMacro[i][0];
                    if (parentID == 254 || parentID == 255 || this.fMacroType[parentID] != 255) continue;
                    this.fMacroToMacro[i][0] = 255;
                    this.fMacroType[i] = 255;
                    changed = true;
                }
            } while (changed);
        }
    }

    public static class RemoteCompilerFromLogo7
    extends CompilerFromLogo7 {
        protected void connect(Block source, int sourceConnectorNr, int reference) {
        }
    }
}

